<?php 

// A class to help work with Sessions
// In our case, primarily to mange logging users in and out

//Keep in mind when working with sessions that it is generally
// inadvisable to store DB-related objects in sessions

class Session2 {
    
    private $logged_in=false;
    public $userid;
    public $fullname;
    public $role;
    public $status;
    public $email;
    
    public $message;
    //userid password fullname role status email
    function __construct() {
        //session_start();
        $this->check_message();
        $this->check_login();
        if($this->logged_in) {
            // actions to take right away if user is logged in
        } else {
            // actions to take right away if user is not logged in
        }
    }
    
    public function is_logged_in() {
        return $this->logged_in;
    }
    
    public function login($user) {
    	//userid password fullname role status email
    	// Sample session value
    	//Array ( [userid] => 111 [fullname] => walid [role] => A [status] => A [email] => walid_tee@yahoo.com ) 
        if($user){
            $this->userid = $_SESSION['userid'] = $user['userid'];
            $this->fullname = $_SESSION['fullname'] = $user['fullname'];
            $this->role = $_SESSION['role'] = $user['role'];
            $this->status = $_SESSION['status'] = $user['status'];
            $this->email = $_SESSION['email'] = $user['email'];
            $this->logged_in  = true;
        }
    }
    
    public function logout() {
       // unset($_SESSION['logged_in']);
    	unset($_SESSION['userid']);
        unset($this->userid);
        $this->logged_in = false;
    }
     
    public function message($msg="") {
        if (!empty($msg)) {
            // then this is "set message"
            // make sure you understand why $this->message=$msg would not work
            $_SESSION['message'] = $msg;
        } else {
            //then this is "get message"
            return $this->message;
        }
    }
    
    private function check_login() {
        if(isset($_SESSION['userid'])) {
            $this->userid = $_SESSION['userid'];
            $this->logged_in = true;
        } else {
            unset($this->userid);
            $this->logged_in = false;
        }
    }
    
    
    private function check_message() {
        // Is there a message stored in the session?
        if (isset($_SESSION['message'])) {
            // Add it as an attribute and erase the stored version
            $this->message = $_SESSION['message'];
            unset($_SESSION['message']);
        } else {
            $this->message = "";
        }
    }
}

$session = new Session2();
$message = $session->message();

?>