<?php
if (! defined ( 'BASEPATH' ))
	exit ( 'No direct script access allowed' );
class session {
	var $prefix="DM_";
	var $admin_prefix="DMA_";
	var $vtr_prefix="DMV_";
	var $instructor_prefix="DMI_";
	function __construct() {
		session_start ();
	}
	function GetUniqueId($isWIthTime=false){
		//$uId=$_SESSION["SID"]
		$uid=$isWIthTime?session_id().time():session_id();
		return md5($uid);
		
	}
	function CleanForSession(&$obj){
		if(method_exists($obj, "CleanForSession")){
			$obj->CleanForSession();
			
		}
		if(is_array($obj)&& is_object($obj)){ foreach ($obj as $key=>$value){
			
			if(method_exists($obj->$key, "CleanForSession")){				
				$this->CleanForSession($obj->$key);
			}
		}
		}
	}
	function SetSession($name, $obj) {
		$this->CleanForSession($obj);
		if (isset ( $_SESSION [$this->prefix.$name] )) {
			unset ( $_SESSION [$this->prefix.$name] );
		}
		$_SESSION [$this->prefix.$name] = serialize ( $obj );
	
	}
	public function set_flashdata($data, $value = NULL)
	{
		$this->set_userdata($data, $value);
		$this->mark_as_flash(is_array($data) ? array_keys($data) : $data);
	}

	public function set_userdata($data, $value = NULL)
	{
		if (is_array($data))
		{
			foreach ($data as $key => &$value)
			{
				$_SESSION[$key] = $value;
			}
	
			return;
		}
	
		$_SESSION[$data] = $value;
	}

	public function mark_as_flash($key)
	{
		if (is_array($key))
		{
			for ($i = 0, $c = count($key); $i < $c; $i++)
			{
			if ( ! isset($_SESSION[$key[$i]]))
			{
			return FALSE;
			}
			}
	
			$new = array_fill_keys($key, 'new');
	
					$_SESSION['__ci_vars'] = isset($_SESSION['__ci_vars'])
				? array_merge($_SESSION['__ci_vars'], $new)
							: $new;
	
							return TRUE;
		}
	
		if ( ! isset($_SESSION[$key]))
		{
		return FALSE;
		}
	
		$_SESSION['__ci_vars'][$key] = 'new';
				return TRUE;
	}	
	public function flashdata($key = NULL)
	{
		if (isset($key))
		{
			return (isset($_SESSION['__ci_vars'], $_SESSION['__ci_vars'][$key], $_SESSION[$key]) && ! is_int($_SESSION['__ci_vars'][$key]))
			? $_SESSION[$key]
			: NULL;
		}
	
		$flashdata = array();
	
		if ( ! empty($_SESSION['__ci_vars']))
		{
			foreach ($_SESSION['__ci_vars'] as $key => &$value)
			{
				is_int($value) OR $flashdata[$key] = $_SESSION[$key];
			}
		}
	
		return $flashdata;
	}
	
	function NewSession(){			
		//session_destroy();
		//session_start();
		foreach ($_SESSION as $key=>$value){
			if($key=="Country"){
				continue;
			}
			unset($_SESSION[$key]);			
		}
	}
	function DestroySession(){
		session_destroy();
	}
	function GetSession($name, $isUnset = false) {		
		$rData = null;
		if (isset ( $_SESSION [$this->prefix.$name] )) {
			$rData = unserialize ( $_SESSION [$this->prefix.$name] );
			if ($isUnset) {
				unset ( $_SESSION [$this->prefix.$name] );
			}
			return $rData;
		} else {
			return null;
		}
	}
	function GetCurrentUserType() {		
	if (isset ( $_SESSION [$this->admin_prefix.'loggedAdminData'] )) {
			$data = $this->GetAdminData();
			if (!empty($data->LoggedIn)) {
				return "AD";
			}
	}
	
	if (isset ( $_SESSION [$this->vtr_prefix.'loggedVtrData'] )) {
		$data = $this->GetVtrData();
		if (!empty($data->LoggedIn)) {
			return "VT";
		}
	}
	
	if (isset ( $_SESSION [$this->instructor_prefix.'loggedInstructorData'] )) {
		$data = $this->GetInstructorData();
		if (!empty($data->LoggedIn)) {
			return "IN";
		}
	}
		if (isset ( $_SESSION [$this->prefix.'loggedCallCenterData'] )) {
			$data = unserialize ( $_SESSION [$this->prefix.'loggedCallCenterData'] );
			if ($data->LoggedIn) {
				return "CC";
			}
		}
		if (isset ( $_SESSION [$this->prefix.'loggedMerchantData'] )) {
			$data = unserialize ( $_SESSION [$this->prefix.'loggedMerchantData'] );
			if ($data->LoggedIn) {
				return "ME";
			}
		}
		if (isset ( $_SESSION [$this->prefix.'loggedUserData'] )) {
			$data = unserialize ( $_SESSION [$this->prefix.'loggedUserData'] );
			if (isset($data->LoggedIn)&& $data->LoggedIn) {
				return "CU";
			}
		} 
			
		return null;
	}
	
	function SetAdminData($obj) {
		$this->CleanForSession($obj);
			if (isset ( $_SESSION [$this->admin_prefix.'loggedAdminData'] )) {
				unset ( $_SESSION [$this->admin_prefix.'loggedAdminData'] );
			}
			$_SESSION [$this->admin_prefix.'loggedAdminData'] = serialize ( $obj );
		}
		
	function GetAdminData() {
		if (isset ( $_SESSION [$this->admin_prefix.'loggedAdminData'] )) {
			return unserialize ( $_SESSION [$this->admin_prefix.'loggedAdminData'] );
		} else {
			return null;
		}
	}
	
	function SetVtrData($obj) {
		$this->CleanForSession($obj);
		if (isset ( $_SESSION [$this->vtr_prefix.'loggedVtrData'] )) {
			unset ( $_SESSION [$this->vtr_prefix.'loggedVtrData'] );
		}
		$_SESSION [$this->vtr_prefix.'loggedVtrData'] = serialize ( $obj );
	}
	
	function GetVtrData() {
		if (isset ( $_SESSION [$this->vtr_prefix.'loggedVtrData'] )) {
			return unserialize ( $_SESSION [$this->vtr_prefix.'loggedVtrData'] );
		} else {
			return null;
		}
	}

	function SetInstructorData($obj) {
		$this->CleanForSession($obj);
		if (isset ( $_SESSION [$this->instructor_prefix.'loggedInstructorData'] )) {
			unset ( $_SESSION [$this->instructor_prefix.'loggedInstructorData'] );
		}
		$_SESSION [$this->instructor_prefix.'loggedInstructorData'] = serialize ( $obj );
	}
	
	function GetInstructorData() {
		if (isset ( $_SESSION [$this->instructor_prefix.'loggedInstructorData'] )) {
			return unserialize ( $_SESSION [$this->instructor_prefix.'loggedInstructorData'] );
		} else {
			return null;
		}
	}
	
	function SetCallCenterData($obj) {
		if (isset ( $_SESSION [$this->prefix.'loggedCallCenterData'] )) {
			unset ( $_SESSION [$this->prefix.'loggedCallCenterData'] );
		}
		$_SESSION [$this->prefix.'loggedCallCenterData'] = serialize ( $obj );
	}
	function GetCallCenterData() {
		if (isset ( $_SESSION [$this->prefix.'loggedCallCenterData'] )) {
			return unserialize ( $_SESSION [$this->prefix.'loggedCallCenterData'] );
		} else {
			return null;
		}
	}
	function IsSession($type){
		$data=null;
		$type=strtoupper($type);
		if($type=="CU"){
			$data=$this->GetUserData();
			
		}elseif($type=="ME"){
			$data=$this->GetMerchantData();			
		}
		elseif($type=="AD"){
			$data=$this->GetAdminData();		
		}
		elseif($type=="CC"){
			$data=$this->GetCallCenterData();		
		}
		if($data){
				return true;
			}
		return false;
	}
	function IssetSession($sessionName){		
		return isset ( $_SESSION [$this->prefix.$sessionName] );
	}
	function SetUserData($obj) {
		$this->CleanForSession($obj);
		//print_r($obj);
	//	echo "<p>Count</p>";
		if (isset ( $_SESSION [$this->prefix.'loggedUserData'] )) {
			unset ( $_SESSION [$this->prefix.'loggedUserData'] );
		}
		$_SESSION [$this->prefix.'loggedUserData'] = serialize ( $obj );
	}
	function UnsetUserData() {
		if (isset ( $_SESSION [$this->prefix.'loggedUserData'] )) {
			unset ( $_SESSION [$this->prefix.'loggedUserData'] );
		}
	
	}
	
	function GetUserData() {
		if (isset ( $_SESSION [$this->prefix.'loggedUserData'] )) {
			$data=unserialize ( $_SESSION [$this->prefix.'loggedUserData'] );
			//print_r($data);
			return unserialize ( $_SESSION [$this->prefix.'loggedUserData'] );
		} else {
			return null;
		}
	}
	
	function UnsetSession($name) {
		if (isset ( $_SESSION [$this->prefix.$name] )) {
			unset ( $_SESSION [$this->prefix.$name] );
		}
	}
	function SetCountryInfo($obj) {
		$this->CleanForSession($obj);
		if (isset ( $_SESSION [$this->prefix.'Country'] )) {
			unset ( $_SESSION [$this->prefix.'Country'] );
		}
		$_SESSION [$this->prefix.'Country'] = serialize ( $obj );
	}
	function GetCountryInfo() {
		if (! isset ( $_SESSION [$this->prefix.'Country'] )) {
			return null;
		}
		$rData = unserialize ( $_SESSION [$this->prefix.'Country'] );
		return $rData;
	}
	function UnsetAllUserData() {
		if (isset ( $_SESSION [$this->admin_prefix.'loggedAdminData'] )) {
			unset ( $_SESSION [$this->admin_prefix.'loggedAdminData'] );
		}		
		if (isset ( $_SESSION [$this->vtr_prefix.'loggedVtrData'] )) {
			unset ( $_SESSION [$this->vtr_prefix.'loggedVtrData'] );
		}
		if (isset ( $_SESSION [$this->instructor_prefix.'loggedInstructorData'] )) {
			unset ( $_SESSION [$this->instructor_prefix.'loggedInstructorData'] );
		}
		if (isset ( $_SESSION [$this->prefix.'loggedUserData'] )) {
			unset ( $_SESSION [$this->prefix.'loggedUserData'] );		
		}
	}
	
	function UnsetFlashData() {
		if (isset ( $_SESSION ['message'] )) {
			unset ( $_SESSION ['message'] );
		}
	}	
}

class AdminSession{
	public $admin_pid;
	public $email;
	public $fname;
	public $lname;
	public $title;
	public $role;
	public $record_per_page;
	public $LoggedIn;
}

class VtrSession{
	public $v_pid;
	public $email;
	public $fname;
	public $lname;
	public $title;
	public $role;
	public $LoggedIn;
}


class InstructorSession{
	public $instructor_id;
	public $instructor_name;
	public $email;
	public $LoggedIn;
}

?>