<?php
class GSController extends CI_Controller {
	protected $except=array();
	var $hiddenField = array ();
	var $errorSession = false;
	var $languageName = "english";
	/**
	  * @var DatamoatUserSession
	  */
	var $userData=null;
	/**
	  * @var DatamoatAdminSession
	  */
	var $adminData=null;
	
	
	function __construct($isAdminPanel=false) {
		parent::__construct ();
		if(!$isAdminPanel){
			$this->userData=$this->session->GetUserData();
			$uType = $this->session->GetCurrentUserType ();
			if (! empty ( $uType )) {
				$this->AddLog ( 'l001', "", "", "V" );
			}
		}else{
			$this->adminData=$this->session->GetAdminData();			
		}
	}
	protected  function CheckSession ($autoRedirect=false){
		$data = $this->session->GetUserData ();
		if (isset($data) && !empty($data->LoggedIn)&& $data->LoggedIn){
			return true;
		}
		if($autoRedirect){
			if(ISAJAX){
				$output=new stdClass();
				$output->auth="f";
				$output->url=site_url("user/login");
				$this->GetJSONData($output);
				die();
			}else{
				redirect("user/login");
				die();
			}
			//$this->
		}
		return false;
	}
	protected function CheckACL(){
		if(!in_array($this->router->method,$this->except)){
			$this->CheckSession(true);
		}	
	}
	function GetLog() {
		$parm = func_get_args ();
		$parm [0] = $this->lang->line ( strtolower ( $parm [0] ) );
		if (isset ( $parm [1] ) && substr_count ( $parm [1], "~" ) > 0) {
			$NewParam = array_merge ( array ($parm [0] ), explode ( "~", $parm [1] ) );
		} else {
			$NewParam = $parm;
		}
		if ((count ( $NewParam ) - 1) >= substr_count ( $parm [0], "%s" )) {
			return call_user_func_array ( "sprintf", $NewParam );
		}
		return "Parametter missing";
	
	}
	
	function AddLog($msgCode = '', $parm = '', $value = "", $type = "V") {
		if ($this->Mlog->AddLog ( $msgCode, $parm, $value, $type )) {
			return true;
		} else {
			return false;
		}
	}
	function AddFeature($str, $isSession = false, $pageMethod = null) {
		if ($isSession) {
			if ($pageMethod == null) {
				Mlog::AddNewFeature ( $str, $this->session, $isSession );
			} else {
				Mlog::AddNewFeature ( $str, $this->session, $isSession );
			}
		} else {
			Mlog::AddNewFeature ( $str, $this->session );
		}
	}
	function AddSystemLog($str, $isSession = false) {
		Mlog::AddSystemLog ( $str, $this->session, $isSession );
	}
	function AddError($error, $isSession = false,$isPTagAdded=false) {
		if ($this->errorSession)
			$isSession = true;
		Mlog::AddError ( $error, $this->session, $isSession ,$isPTagAdded);
	}
	function AddInfo($info, $isSession = false,$isPTagAdded=false) {
		Mlog::AddInfo ( $info, $this->session, $isSession,$isPTagAdded);
	}
	function GetError($isArrayReturn=false) {
		return Mlog::GetError ( $this->session ,$isArrayReturn);
	}
	function GetInfo($isArrayReturn=false) {
		return Mlog::GetInfo ( $this->session ,$isArrayReturn);
	}
	
	function GetSysLog() {
		return Mlog::GetSystemLog ( $this->session );
	}
	function AddDebugMsg($str, $status = StatusOk) {
		if (IsDebugMode) {
			Mlog::AddDebugMsg ( $str, $status, $this->session, true );
		}
	}
	function GetDebugMsg() {
		return Mlog::GetDebugMsg ( $this->session );
	}
	function AddHiddenField($name, $value) {
		$a = count ( $this->hiddenField );
		$this->hiddenField [$a]=new stdClass();
		$this->hiddenField [$a]->name = $name;
		$this->hiddenField [$a]->value = $value;
	}
	function AddPostValueAsHiddenField($except = "") {
		$exArray = preg_split ( "/\,/", $except );
		$a = count ( $this->hiddenField );
		foreach ( $_POST as $name => $value ) {
			if (is_array ( $exArray ) && in_array ( $name, $exArray ))
				continue;
			$this->hiddenField [$a]->name = $name;
			$this->hiddenField [$a]->value = $this->input->post ( $name, true );
			$a ++;
		}
	}	
	function SetWaitingForServerResponse($sessionName, $isComplete = false) {
		if ($isComplete) {
			$this->session->UnsetSession ( $sessionName );
		} else {
			$this->session->SetSession ( $sessionName, true );
		}
	}
	function IsWaitingForServerResponse($sessionName) {
		return $this->session->GetSession ( $sessionName );
	
	}
	function AddOldFields($obj, $properties) {
	//	GPrint($obj); die;
		$properties = str_replace ( " ", "", $properties );
		$properties = preg_split ( "/\,/", $properties );
		if (count ( $properties ) > 0) {
			foreach ( $properties as $property ) {				
				if (isset ( $obj->$property )) {
					$a = count ( $this->hiddenField );
					$this->hiddenField [$a]=new stdClass();
					$this->hiddenField [$a]->name = "old_" . $property;
					$this->hiddenField [$a]->value = $obj->$property;
				}
			}
		}	
	
	}
	
	protected function GetDefaultConfiguration(&$rData, $DisbleButton = false) {
		$this->load->library ( 'user_agent' );
		$version = str_split ( $this->agent->version (), 2 );
		$rData ['CurrentUserType'] = isset ( $this->session ) ? $this->session->GetCurrentUserType () : null;
		$rData ['UserLoggedIn'] = $rData ['CurrentUserType'] == "CU" || $this->session->GetUserData () ? true : false;
		//$rData ['UserName'] = $rData ['CurrentUserType'] == "CC" ? $this->session->GetCallCenterData ()->userName : ($rData ['CurrentUserType'] == "AD" ? $this->session->GetAdminData ()->userName : ($rData ['CurrentUserType'] == "ME" ? DIDFormat ( $this->session->GetMerchantData ()->userName, $this->CountryInfo->countryPhoneFormat, strlen ( $this->CountryInfo->countryPhoneCode ) ) . " , Staff : " . $this->session->GetMerchantData ()->staffName : ""));
		$rData ['BrowserVersion'] = ( double ) ((( int ) $version [0]) . "." . (( int ) $version [1]));
		$rData ['BrowserName'] = strtolower ( $this->agent->browser () );
		$rData ['ipaddress']=$this->input->ip_address();
		//$rData ['agent']=$this->agent;
		$this->input->ip_address();
		$rData ['formClass'] = "form-horizontal";
		$rData ['error'] = $this->GetError ();	
		$rData ['info'] = $this->GetInfo ();
		$rData ['SysLog'] = $this->GetSysLog ();
		$rData ['DebugMsg'] = IsDebugMode ? ($this->GetDebugMsg ()) : null;
		$rData ['hiddenFields'] = $this->hiddenField;
		if (! isset ( $rData ['PostUrl'] )) {
			$rData ['PostUrl'] = site_url ( $this->uri->uri_string () );
		}
		if ($DisbleButton) {
			$rData ['ButtonValue'] = null;
		}	
		$rData['AutoMsgShow']=true;
	}
	function CheckRecapcha(){
		if(!IsChapcha()){
			return true;
		}
			$publickey = "6LckwswSAAAAAPH2z4qxHj8AT_ziPd2DAzAdPyKw";
			$privatekey = "6LckwswSAAAAAFkJH7i1zx-4YSwl5HFXVomUkgHI";		
			# the response from reCAPTCHA
			$resp = null;
			# the error code from reCAPTCHA, if any
			$error = null;		
			# was there a reCAPTCHA response?
			if ($_POST["recaptcha_response_field"] != "") {
			        $resp = recaptcha_check_answer ($privatekey,
			                                        $_SERVER["REMOTE_ADDR"],
			                                        $_POST["recaptcha_challenge_field"],
			                                        $_POST["recaptcha_response_field"]);
			
			        if ($resp->is_valid) {
			                return true;
			        } else {
			                # set the error code so that we can display it
			                $this->AddError("Captcha is not Correct");
			               return false;
			        }
			} else {
				$this->AddError("Captcha field Empty!");
			}
		}
	protected function CleanDataObj(&$data){
		foreach ($data as &$d){
			if(isset($d->setProperties)){
				unset($d->setProperties);
			}
			if(isset($d->validations)){
				unset($d->validations);
			}
			if(isset($d->tableName)){
				unset($d->tableName);
			}
			if(isset($d->primaryKey)){
				unset($d->primaryKey);
			}
			if(isset($d->setOption)){
				unset($d->setOption);
			}
			if(isset($d->strPrpertyForLog)){
				unset($d->strPrpertyForLog);
			}
		}
	}
	protected function GetJSONData($data=array(),$isJson=true,$isClean=false,$optionalInfo=null){
		if($isClean){
			$this->CleanDataObj($data);
		}
		$obj=null;
		$error=null;
		$info=null;	
		$error=new stdClass();	
		$error->Type="Error";
		$error->Msg=$this->GetError();	
		$info=new stdClass();	
		$info->Type="Info";
		$info->Msg=$this->GetInfo();
		$obj=new stdClass();		
		$obj->Messages=array($error,$info);
		$obj->Notification=array();
		$obj->OptionalInfo=$optionalInfo;
		$obj->Data=$data;
		if(IsDebugMode){
			$obj->DebugLog=$this->GetDebugMsg()."<br/><hr/><br/>".GSModel::GetTotalQuerts();
		}else{
			$obj->DebugLog="";
		}
		$obj->HiddenFields=$this->hiddenField;
		/*if($isJson){
			echo  json_encode($obj,JSON_UNESCAPED_UNICODE);
		}else{*/
			echo json_encode($obj);
		//}
	}
	/**
	 * Get ULR Param/Data from indexed 3 ...
	 */
	protected function GetUriArray() {
		return $this->uri->uri_to_assoc ( 3 );
	}
}